function [KGb] = Kglobal(MatID,Node,Elem)
% Assembles the global stiffness matrix
Nnode = size(Node,1);
Nelem = size(Elem,1);
KGb = zeros(2*Nnode,2*Nnode);
for i = 1:Nelem,
    YM = MatID(Elem(i,2),2);
    nu = MatID(Elem(i,2),3);
    t = MatID(Elem(i,2),4);
    % constitutive matrix for plane-stress
    dummy = YM/(1-nu*nu);
    D(1,1) = dummy;
    D(1,2) = dummy*nu;
    D(1,3) = 0.0;
    D(2,1) = D(1,2);
    D(2,2) = D(1,1);
    D(2,3) = 0.0;
    D(3,1) = 0.0;
    D(3,2) = 0.0;
    D(3,3) = dummy*(1-nu)/2;
    % Getting the element stiffness matrix
    [K] = Kelem(D,i,t);
    for j = 3:6
        for k = 3:6
            KGb(2*Elem(i,j)-1,2*Elem(i,k)-1) = KGb(2*Elem(i,j)-1,2*Elem(i,k)-1) + K(2*j-5,2*k-5);
            KGb(2*Elem(i,j),2*Elem(i,k))     = KGb(2*Elem(i,j),2*Elem(i,k)) + K(2*j-4,2*k-4);
            KGb(2*Elem(i,j)-1,2*Elem(i,k))   = KGb(2*Elem(i,j)-1,2*Elem(i,k)) + K(2*j-5,2*k-4);
            KGb(2*Elem(i,j),2*Elem(i,k)-1)   = KGb(2*Elem(i,j),2*Elem(i,k)-1) + K(2*j-4,2*k-5);
        end
    end 
end